<?php
// HATA GÖRMEK İSTEMEZSEN BU İKİ SATIRI SİLEBİLİRSİN
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!file_exists(__DIR__ . '/includes/config.php')) {
    die('includes/config.php bulunamadı');
}
require_once __DIR__ . '/includes/config.php';

// ========== AYAR FONKSİYONU ==========
if (!function_exists('getSetting')) {
    function getSetting($key, $default = '') {
        global $pdo;
        $q = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = ?");
        $q->execute([$key]);
        $val = $q->fetchColumn();
        return $val !== false ? $val : $default;
    }
}

// ========== SLUG / KATEGORİ ==========
$slug = $_GET['slug'] ?? '';
if ($slug === '') {
    header('Location: index.php');
    exit;
}

$stmt = $pdo->prepare("SELECT * FROM categories WHERE slug = ? AND is_active = 1");
$stmt->execute([$slug]);
$category = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$category) {
    header('Location: index.php');
    exit;
}

// ========== TÜM KATEGORİLER (SLIDER İÇİN) ==========
$allCats = $pdo->query("
    SELECT * FROM categories 
    WHERE is_active = 1 
    ORDER BY display_order ASC, name ASC
")->fetchAll(PDO::FETCH_ASSOC);

// ========== ÜRÜNLER ==========
$stmt = $pdo->prepare("
    SELECT * FROM products 
    WHERE category_id = ? 
      AND is_active = 1
    ORDER BY display_order ASC, name ASC
");
$stmt->execute([$category['id']]);
$products = $stmt->fetchAll(PDO::FETCH_ASSOC);

// ========== AYARLAR ==========
$currency = getSetting('currency', '₺');

// ========== DİNAMİK GÜN / SAAT MESAJI ==========
$days = [
    1 => 'Pazartesi',
    2 => 'Salı',
    3 => 'Çarşamba',
    4 => 'Perşembe',
    5 => 'Cuma',
    6 => 'Cumartesi',
    7 => 'Pazar'
];

$dayName = $days[(int)date('N')] ?? '';
$hour    = (int)date('H');

if ($hour < 11) {
    $timeMessage = 'Hafif ve ferah seçeneklerle güne başlayın.';
} elseif ($hour < 17) {
    $timeMessage = 'Öğle arası menümüz hazır.';
} elseif ($hour < 23) {
    $timeMessage = 'Akşam servisi başladı.';
} else {
    $timeMessage = 'Gece atıştırmalıkları için ideal seçenekler.';
}

?>
<!doctype html>
<html lang="tr">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">

<title><?= htmlspecialchars($category['name']) ?> | Menü</title>

<script src="https://cdn.tailwindcss.com"></script>
<style>
body{font-family:system-ui,-apple-system,BlinkMacSystemFont,"Segoe UI",sans-serif}
.active-cat{outline:3px solid #facc15;}
body{background:#1f2933 !important;}
</style>
</head>

<body class="bg-gradient-to-b from-[#f8f3e9] to-[#f0e7d7] text-neutral-900">

<!-- HEADER -->
<header class="bg-white/90 backdrop-blur border-b border-neutral-200">
  <div class="max-w-xl mx-auto px-4 py-3 flex items-center gap-3">
    <a href="index.php" class="text-xl leading-none">←</a>
    <div>
      <h1 class="text-lg font-semibold"><?= htmlspecialchars($category['name']) ?></h1>
      <div class="inline-flex items-center gap-2 mt-2 px-3 py-1.5 rounded-lg
            bg-[#f3e8da] border border-[#d6c6b2] shadow-sm">
    
    <span class="text-[11px] font-medium text-[#6b4f2c]">
        <?= htmlspecialchars($dayName) ?>
    </span>

    <span class="w-px h-3 bg-[#c8b29a]"></span>

    <span class="text-[11px] text-[#6b4f2c]">
        <?= htmlspecialchars($timeMessage) ?>
    </span>
</div>

    </div>
  </div>
</header>

<!-- YATAY KATEGORİ SLIDER -->
<div class="px-3 pt-3 overflow-x-auto">
  <div class="flex gap-3 w-max pb-2">
    <?php foreach ($allCats as $cat): ?>
      <a href="category.php?slug=<?= urlencode($cat['slug']) ?>"
         class="shrink-0 w-28 h-20 rounded-xl overflow-hidden relative shadow-sm <?= $cat['id'] == $category['id'] ? 'active-cat' : '' ?>">

        <?php if (!empty($cat['image'])): ?>
          <img src="<?= htmlspecialchars($cat['image']) ?>" class="w-full h-full object-cover" alt="<?= htmlspecialchars($cat['name']) ?>">
        <?php else: ?>
          <div class="w-full h-full bg-neutral-300"></div>
        <?php endif; ?>

        <div class="absolute inset-0 bg-black/40 flex items-center justify-center px-1">
          <span class="text-[11px] text-white font-medium text-center leading-tight">
            <?= htmlspecialchars($cat['name']) ?>
          </span>
        </div>

      </a>
    <?php endforeach; ?>
  </div>
</div>

<!-- ÜRÜN LİSTESİ -->
<main class="max-w-xl mx-auto px-4 py-5 space-y-3 pb-10">

  <?php if (empty($products)): ?>
    <div class="p-4 bg-white/80 rounded-xl text-sm text-neutral-600 shadow-sm">
      Bu kategoriye ait aktif ürün bulunamadı.
    </div>
  <?php endif; ?>

  <?php foreach ($products as $p): ?>
    <div class="bg-white/95 rounded-2xl p-3 shadow-sm flex gap-3">

      <!-- ÜRÜN GÖRSELİ -->
      <!-- ÜRÜN İKONU -->
<div class="w-12 h-12 rounded-full bg-neutral-100 flex items-center justify-center flex-shrink-0">
    <svg xmlns="http://www.w3.org/2000/svg" 
         class="w-6 h-6 text-neutral-500" 
         fill="none" 
         viewBox="0 0 24 24" 
         stroke="currentColor" 
         stroke-width="1.8">
        <!-- Tabak / yemek ikonu -->
        <path stroke-linecap="round" stroke-linejoin="round"
              d="M4 3h16M4 21h16M7 6v6a5 5 0 0010 0V6M7 6h10" />
    </svg>
</div>


      <!-- ÜRÜN BİLGİLERİ -->
      <div class="flex-1 flex flex-col justify-between">
        <div class="flex justify-between gap-2">
          <h3 class="font-semibold text-sm leading-snug">
            <?= htmlspecialchars($p['name']) ?>
          </h3>

          <?php if ($p['price'] > 0): ?>
            <div class="ml-2 text-right">
              <span class="text-[11px] text-neutral-400 block">···</span>
              <span class="text-[13px] font-semibold text-neutral-700">
                <?= number_format($p['price'], 0, ',', '.') . $currency ?>
              </span>
            </div>
          <?php endif; ?>
        </div>

        <?php if (!empty($p['description'])): ?>
          <p class="text-[11px] text-neutral-500 mt-1">
            <?= htmlspecialchars($p['description']) ?>
          </p>
        <?php endif; ?>
      </div>

    </div>
  <?php endforeach; ?>

</main>

</body>
</html>
