<?php
if (!file_exists('includes/config.php')) {
    header('Location: setup.php');
    exit;
}
require_once 'includes/config.php';

$stmt = $pdo->query("SELECT * FROM categories WHERE is_active=1 ORDER BY display_order ASC");
$categories = $stmt->fetchAll();

function getSetting($key,$default=''){
    global $pdo;
    $s=$pdo->prepare("SELECT setting_value FROM settings WHERE setting_key=?");
    $s->execute([$key]);
    $r=$s->fetchColumn();
    return $r!==false?$r:$default;
}

$restaurant = getSetting('restaurant_name','Luxury Restaurant');
$phone = getSetting('phone','');
$maps = getSetting('maps_url','#');
?>
<!doctype html>
<html lang="tr">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title><?= htmlspecialchars($restaurant) ?> | Menü</title>

<script src="https://cdn.tailwindcss.com"></script>
<link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@500;600;700&family=Inter:wght@400;500;600&display=swap" rel="stylesheet">

<style>
body{font-family:'Inter',sans-serif}
.title{font-family:'Playfair Display',serif}
.gold{color:#d4af37}
.bg-gold{background:#d4af37}
.gold-border{border-color:#d4af37}
.overlay{background:linear-gradient(to top,rgba(0,0,0,.85),rgba(0,0,0,.2))}
</style>
</head>

<body class="bg-black text-white">

<!-- ÜST BAR -->
<header class="sticky top-0 z-50 bg-black/90 backdrop-blur border-b border-neutral-800">
  <div class="max-w-xl mx-auto flex justify-between items-center px-4 py-3">
    <div class="title text-lg tracking-wide gold"><?= htmlspecialchars($restaurant) ?></div>
    <div class="flex gap-3 text-sm">
      <a href="<?= htmlspecialchars($maps) ?>" class="gold">Konum</a>
      <a href="tel:<?= htmlspecialchars($phone) ?>" class="gold">Ara</a>
    </div>
  </div>
</header>

<!-- HERO -->
<section class="max-w-xl mx-auto px-4 py-8">
  <h1 class="title text-4xl font-bold mb-2">Dijital Menü</h1>
  <p class="text-neutral-400 text-sm">Özenle seçilmiş lezzetler</p>
  <div class="w-24 h-[1px] bg-gold mt-4"></div>
</section>

<!-- KATEGORİLER -->
<section class="max-w-xl mx-auto px-4 space-y-5 pb-32">

<?php foreach($categories as $cat): ?>
<a href="category.php?slug=<?= urlencode($cat['slug']) ?>"
   class="block overflow-hidden rounded-2xl border border-neutral-800 hover:border-gold transition">

<?php if($cat['image'] && file_exists($cat['image'])): ?>
  <div class="relative h-44">
    <img src="<?= htmlspecialchars($cat['image']) ?>" class="w-full h-full object-cover">
    <div class="absolute inset-0 overlay"></div>
    <div class="absolute bottom-4 left-4">
      <h2 class="title text-2xl gold"><?= htmlspecialchars($cat['name']) ?></h2>
      <span class="text-sm text-neutral-300">Menüyü görüntüle</span>
    </div>
  </div>
<?php else: ?>
  <div class="p-5 flex justify-between items-center">
    <div>
      <h2 class="title text-xl gold"><?= htmlspecialchars($cat['name']) ?></h2>
      <span class="text-sm text-neutral-400">Menüyü aç</span>
    </div>
    <span class="text-gold text-xl">›</span>
  </div>
<?php endif; ?>

</a>
<?php endforeach; ?>

</section>

<!-- ALT SABİT BAR -->
<footer class="fixed bottom-0 left-0 right-0 bg-black border-t border-neutral-800">
  <div class="max-w-xl mx-auto flex text-sm">
    <a href="tel:<?= htmlspecialchars($phone) ?>" class="w-1/2 py-3 text-center gold border-r border-neutral-800">Ara</a>
    <a href="<?= htmlspecialchars($maps) ?>" class="w-1/2 py-3 text-center gold">Konum</a>
  </div>
</footer>

</body>
</html>
