<?php
if(!file_exists('includes/config.php')){
    header("Location:setup.php");exit;
}
require_once 'includes/config.php';

/* ========= SLUG ========= */
$slug = $_GET['slug'] ?? '';
if($slug==''){ header("Location:index.php"); exit; }

/* ========= AKTİF KATEGORİ ========= */
$c = $pdo->prepare("SELECT * FROM categories WHERE slug=? AND is_active=1");
$c->execute([$slug]);
$category = $c->fetch(PDO::FETCH_ASSOC);
if(!$category){ header("Location:index.php"); exit; }

/* ========= ÜST KATEGORİ MENÜSÜ ========= */
$topCats = $pdo->query("
    SELECT * FROM categories 
    WHERE is_active=1 
    ORDER BY display_order ASC
")->fetchAll(PDO::FETCH_ASSOC);

/* ========= ALT KATEGORİLER ========= */
$s = $pdo->prepare("
    SELECT * FROM subcategories 
    WHERE category_id=? 
    ORDER BY display_order ASC
");
$s->execute([$category['id']]);
$subs = $s->fetchAll(PDO::FETCH_ASSOC);

/* ========= ÜRÜNLER ========= */
$items = [];
if($subs){
    foreach($subs as $sub){
        $q = $pdo->prepare("
            SELECT p.* FROM products p
            JOIN product_subcategories ps ON p.id = ps.product_id
            WHERE ps.subcategory_id = ? AND p.is_active = 1
            ORDER BY p.display_order ASC, p.name ASC
        ");
        $q->execute([$sub['id']]);
        $items[$sub['id']] = $q->fetchAll(PDO::FETCH_ASSOC);
    }
}else{
    $q = $pdo->prepare("
        SELECT * FROM products 
        WHERE category_id=? AND is_active=1
        ORDER BY display_order ASC, name ASC
    ");
    $q->execute([$category['id']]);
    $products = $q->fetchAll(PDO::FETCH_ASSOC);
}

/* ========= AYAR ========= */
function getSetting($k,$d=''){
    global $pdo;
    $s=$pdo->prepare("SELECT setting_value FROM settings WHERE setting_key=?");
    $s->execute([$k]);
    $r=$s->fetchColumn();
    return $r!==false?$r:$d;
}
$currency = getSetting('currency','₺');
?>
<!doctype html>
<html lang="tr">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">

<title><?= htmlspecialchars($category['name']) ?></title>

<script src="https://cdn.tailwindcss.com"></script>
<link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@600;700&family=Inter:wght@400;500&display=swap" rel="stylesheet">

<style>
body{font-family:'Inter',sans-serif}
.title{font-family:'Playfair Display',serif}
.gold{color:#d4af37}
.overlay{background:linear-gradient(to top,rgba(0,0,0,.9),rgba(0,0,0,.3))}
.cat-glass{background:rgba(0,0,0,.55);backdrop-filter:blur(6px)}
.cat-active{outline:2px solid #d4af37}
</style>
</head>

<body class="bg-black text-white">

<!-- HEADER -->
<header class="sticky top-0 z-50 bg-black/90 border-b border-neutral-800">
  <div class="max-w-xl mx-auto px-4 py-3 flex justify-between">
    <a href="index.php" class="gold">← Menü</a>
  </div>
</header>

<!-- ÜST KATEGORİ MENÜSÜ -->
<div class="cat-glass border-b border-neutral-800">
  <div class="max-w-xl mx-auto px-3 py-3 overflow-x-auto">
    <div class="flex gap-3 w-max">

      <?php foreach($topCats as $tc): ?>
      <a href="category.php?slug=<?= urlencode($tc['slug']) ?>"
         class="relative shrink-0 w-28 h-20 rounded-xl overflow-hidden shadow
         <?= $tc['id']==$category['id'] ? 'cat-active' : '' ?>">

        <?php if($tc['image'] && file_exists($tc['image'])): ?>
        <img src="<?= htmlspecialchars($tc['image']) ?>" class="w-full h-full object-cover">
        <?php endif; ?>

        <div class="absolute inset-0 bg-black/60 flex items-center justify-center">
          <span class="title text-xs gold text-center px-1">
            <?= htmlspecialchars($tc['name']) ?>
          </span>
        </div>

      </a>
      <?php endforeach; ?>

    </div>
  </div>
</div>

<!-- KAPAK -->
<?php if($category['image'] && file_exists($category['image'])): ?>
<div class="relative h-56">
  <img src="<?= htmlspecialchars($category['image']) ?>" class="w-full h-full object-cover">
  <div class="absolute inset-0 overlay"></div>
  <div class="absolute bottom-4 left-4">
    <h1 class="title text-3xl gold"><?= htmlspecialchars($category['name']) ?></h1>
  </div>
</div>
<?php else: ?>
<div class="px-4 py-6 max-w-xl mx-auto">
  <h1 class="title text-3xl gold"><?= htmlspecialchars($category['name']) ?></h1>
</div>
<?php endif; ?>

<!-- ÜRÜNLER -->
<div class="max-w-xl mx-auto px-4 py-6 pb-24">

<?php if($subs): ?>
<?php foreach($subs as $sub): if(!empty($items[$sub['id']])): ?>
<h2 class="title text-xl gold mt-8 mb-3"><?= htmlspecialchars($sub['name']) ?></h2>
<div class="space-y-3">
<?php foreach($items[$sub['id']] as $p): ?>
<div class="border-b border-neutral-800 pb-3">
  <div class="flex justify-between items-start">
    <div>
      <h3 class="font-medium"><?= htmlspecialchars($p['name']) ?></h3>
      <?php if($p['description']): ?>
      <p class="text-sm text-neutral-400 mt-1"><?= htmlspecialchars($p['description']) ?></p>
      <?php endif; ?>
    </div>
    <?php if($p['price']>0): ?>
    <span class="gold font-semibold">
      <?= number_format($p['price'],0,",",".").$currency ?>
    </span>
    <?php endif; ?>
  </div>
</div>
<?php endforeach; ?>
</div>
<?php endif; endforeach; ?>

<?php else: ?>
<div class="space-y-3">
<?php foreach($products as $p): ?>
<div class="border-b border-neutral-800 pb-3 flex justify-between">
  <div>
    <h3 class="font-medium"><?= htmlspecialchars($p['name']) ?></h3>
    <?php if($p['description']): ?>
    <p class="text-sm text-neutral-400 mt-1"><?= htmlspecialchars($p['description']) ?></p>
    <?php endif; ?>
  </div>
  <?php if($p['price']>0): ?>
  <span class="gold font-semibold">
    <?= number_format($p['price'],0,",",".").$currency ?>
  </span>
  <?php endif; ?>
</div>
<?php endforeach; ?>
</div>
<?php endif; ?>

</div>

</body>
</html>
