<?php
if (!file_exists('includes/config.php')) {
    header('Location: setup.php');
    exit;
}
require_once 'includes/config.php';

$stmt = $pdo->query("SELECT * FROM categories WHERE is_active = 1 ORDER BY display_order ASC, name ASC");
$categories = $stmt->fetchAll();

function getSetting($key, $default = '') {
    global $pdo;
    $stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = ?");
    $stmt->execute([$key]);
    $val = $stmt->fetchColumn();
    return $val !== false ? $val : $default;
}

$restaurant_name = getSetting('restaurant_name','Demo QR Menü');
$phone = getSetting('phone','0500000000');
$maps_url = getSetting('maps_url','#');
$price_update_date = getSetting('price_update_date',date('d.m.Y'));
?>
<!doctype html>
<html lang="tr">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title><?= htmlspecialchars($restaurant_name) ?> | Menü</title>

<script src="https://cdn.tailwindcss.com"></script>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">

<style>
body{font-family:'Inter',sans-serif}
.cover{background:linear-gradient(to top,rgba(0,0,0,.65),rgba(0,0,0,.05))}
</style>
</head>

<body class="bg-neutral-100 text-neutral-900">

<!-- ÜST BAR -->
<header class="sticky top-0 z-50 bg-white shadow-sm">
  <div class="flex items-center justify-between px-4 py-3 max-w-xl mx-auto">
    <div class="font-extrabold text-lg"><?= htmlspecialchars($restaurant_name) ?></div>
    <div class="flex gap-3">
      <a href="<?= htmlspecialchars($maps_url) ?>" target="_blank" class="text-sm px-3 py-1.5 rounded-full bg-neutral-900 text-white">Konum</a>
      <a href="tel:<?= htmlspecialchars($phone) ?>" class="text-sm px-3 py-1.5 rounded-full border">Ara</a>
    </div>
  </div>
</header>

<!-- HERO -->
<section class="max-w-xl mx-auto px-4 mt-5 mb-6">
  <div class="rounded-3xl bg-gradient-to-br from-neutral-900 to-neutral-700 text-white p-6">
    <h1 class="text-3xl font-extrabold mb-2">Dijital Menü</h1>
    <p class="text-sm opacity-90">Kategorilere dokun ve ürünleri keşfet</p>
    <p class="text-xs mt-3 opacity-70">Güncelleme: <?= htmlspecialchars($price_update_date) ?></p>
  </div>
</section>

<!-- KATEGORİLER -->
<section class="max-w-xl mx-auto px-4 space-y-4 pb-10">

<?php foreach($categories as $cat): ?>
<a href="category.php?slug=<?= urlencode($cat['slug']) ?>"
   class="block rounded-3xl overflow-hidden shadow hover:scale-[1.01] transition bg-white">

  <?php if($cat['image'] && file_exists($cat['image'])): ?>
    <div class="relative h-36">
      <img src="<?= htmlspecialchars($cat['image']) ?>" class="w-full h-full object-cover">
      <div class="absolute inset-0 cover"></div>
      <div class="absolute bottom-3 left-4">
        <h2 class="text-white text-xl font-bold">
          <?= htmlspecialchars($cat['name']) ?>
        </h2>
        <p class="text-white/80 text-sm">Menüyü görüntüle</p>
      </div>
    </div>
  <?php else: ?>
    <div class="p-5 flex items-center justify-between">
      <div>
        <h2 class="text-lg font-bold"><?= htmlspecialchars($cat['name']) ?></h2>
        <p class="text-sm text-neutral-500">Menüyü aç</p>
      </div>
      <span class="text-xl">›</span>
    </div>
  <?php endif; ?>

</a>
<?php endforeach; ?>

</section>

<!-- ALT SABİT BAR -->
<footer class="fixed bottom-0 left-0 right-0 bg-white border-t">
  <div class="max-w-xl mx-auto flex text-sm">
    <a href="tel:<?= htmlspecialchars($phone) ?>" class="w-1/2 py-3 text-center font-semibold">📞 Ara</a>
    <a href="<?= htmlspecialchars($maps_url) ?>" target="_blank" class="w-1/2 py-3 text-center font-semibold border-l">📍 Konum</a>
  </div>
</footer>

</body>
</html>
