<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? h($page_title) . ' - ' : ''; ?>QR Menü Admin Panel</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap');
        body { font-family: 'Inter', sans-serif; }
    </style>
</head>
<body class="bg-gray-50">
    <!-- Top Navigation Bar -->
    <nav class="bg-gradient-to-r from-amber-600 to-orange-600 shadow-lg sticky top-0 z-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16">
                <div class="flex items-center">
                    <!-- Logo -->
                    <a href="index.php" class="flex items-center">
                        <svg class="w-8 h-8 text-white mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path>
                        </svg>
                        <span class="text-white text-xl font-bold">QR Admin</span>
                    </a>
                    
                    <!-- Main Navigation -->
                    <div class="hidden md:flex ml-10 space-x-1">
                        <a href="index.php" class="px-4 py-2 rounded-lg text-white hover:bg-white/20 transition <?php echo basename($_SERVER['PHP_SELF']) == 'index.php' ? 'bg-white/20' : ''; ?>">
                            Dashboard
                        </a>
                        <a href="categories.php" class="px-4 py-2 rounded-lg text-white hover:bg-white/20 transition <?php echo basename($_SERVER['PHP_SELF']) == 'categories.php' ? 'bg-white/20' : ''; ?>">
                            Kategoriler
                        </a>
                        <a href="products.php" class="px-4 py-2 rounded-lg text-white hover:bg-white/20 transition <?php echo basename($_SERVER['PHP_SELF']) == 'products.php' ? 'bg-white/20' : ''; ?>">
                            Ürünler
                        </a>
                        <a href="settings.php" class="px-4 py-2 rounded-lg text-white hover:bg-white/20 transition <?php echo basename($_SERVER['PHP_SELF']) == 'settings.php' ? 'bg-white/20' : ''; ?>">
                            Ayarlar
                        </a>
                    </div>
                </div>

                <!-- Right Side Menu -->
                <div class="flex items-center space-x-4">
                    <!-- View Site -->
                    <a href="../index.php" target="_blank" class="text-white hover:text-gray-200 transition" title="Menüyü Görüntüle">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"></path>
                        </svg>
                    </a>

                    <!-- User Menu -->
                    <div class="relative" x-data="{ open: false }">
                        <button @click="open = !open" class="flex items-center text-white hover:text-gray-200 focus:outline-none">
                            <svg class="w-6 h-6 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                            </svg>
                            <span class="hidden md:block"><?php echo h($_SESSION['admin_username']); ?></span>
                            <svg class="w-4 h-4 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                            </svg>
                        </button>
                        
                        <div x-show="open" @click.away="open = false" 
                             class="absolute right-0 mt-2 w-48 bg-white rounded-lg shadow-xl py-1 z-50"
                             x-transition:enter="transition ease-out duration-100"
                             x-transition:enter-start="transform opacity-0 scale-95"
                             x-transition:enter-end="transform opacity-100 scale-100"
                             x-transition:leave="transition ease-in duration-75"
                             x-transition:leave-start="transform opacity-100 scale-100"
                             x-transition:leave-end="transform opacity-0 scale-95"
                             style="display: none;">
                            <a href="profile.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                Profil
                            </a>
                            <a href="settings.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                Ayarlar
                            </a>
                            <hr class="my-1">
                            <a href="logout.php" class="block px-4 py-2 text-sm text-red-600 hover:bg-red-50">
                                Çıkış Yap
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </nav>

    <!-- Mobile Navigation -->
    <div class="md:hidden bg-white border-b border-gray-200">
        <div class="flex overflow-x-auto px-4 py-2 space-x-2">
            <a href="index.php" class="px-4 py-2 rounded-lg text-sm font-medium whitespace-nowrap <?php echo basename($_SERVER['PHP_SELF']) == 'index.php' ? 'bg-amber-100 text-amber-700' : 'text-gray-600 hover:bg-gray-100'; ?>">
                Dashboard
            </a>
            <a href="categories.php" class="px-4 py-2 rounded-lg text-sm font-medium whitespace-nowrap <?php echo basename($_SERVER['PHP_SELF']) == 'categories.php' ? 'bg-amber-100 text-amber-700' : 'text-gray-600 hover:bg-gray-100'; ?>">
                Kategoriler
            </a>
            <a href="products.php" class="px-4 py-2 rounded-lg text-sm font-medium whitespace-nowrap <?php echo basename($_SERVER['PHP_SELF']) == 'products.php' ? 'bg-amber-100 text-amber-700' : 'text-gray-600 hover:bg-gray-100'; ?>">
                Ürünler
            </a>
            <a href="settings.php" class="px-4 py-2 rounded-lg text-sm font-medium whitespace-nowrap <?php echo basename($_SERVER['PHP_SELF']) == 'settings.php' ? 'bg-amber-100 text-amber-700' : 'text-gray-600 hover:bg-gray-100'; ?>">
                Ayarlar
            </a>
        </div>
    </div>

    <!-- Main Content -->
    <main class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <!-- Page Header -->
        <?php if (isset($page_title)): ?>
        <div class="mb-6">
            <h1 class="text-3xl font-bold text-gray-900"><?php echo h($page_title); ?></h1>
            <?php if (isset($page_description)): ?>
                <p class="mt-1 text-sm text-gray-600"><?php echo h($page_description); ?></p>
            <?php endif; ?>
        </div>
        <?php endif; ?>

        <!-- Messages -->
        <?php echo displayMessages(); ?>
