<?php
// Kurulum kontrolü
if (!file_exists('includes/config.php')) {
    header('Location: setup.php');
    exit;
}

require_once 'includes/config.php';

// Tüm aktif kategorileri çek
$stmt = $pdo->query("SELECT * FROM categories WHERE is_active = 1 ORDER BY display_order ASC, name ASC");
$categories = $stmt->fetchAll();

// Ayarları çek
$restaurant_name = getSetting('restaurant_name', 'Demo');
$phone = getSetting('phone', '05078531610');
$maps_url = getSetting('maps_url', 'https://maps.app.goo.gl/XbFYeuwkYQBQJwxu7');
$price_update_date = getSetting('price_update_date', date('d F Y'));

function getSetting($key, $default = '') {
    global $pdo;
    $stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = ?");
    $stmt->execute([$key]);
    $result = $stmt->fetchColumn();
    return $result !== false ? $result : $default;
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?php echo htmlspecialchars($restaurant_name); ?> - QR Menü</title>
  <meta name="description" content="<?php echo htmlspecialchars($restaurant_name); ?> dijital menüsü - Cafe, Restaurant ve At Binicilik">
  <meta name="theme-color" content="#8b5e3c">
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap');
    body { font-family: 'Poppins', sans-serif; }
    
    /* Smooth scroll */
    html { scroll-behavior: smooth; }
    
    /* Category card hover effect */
    .category-card {
      transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }
    .category-card:hover {
      transform: translateY(-8px);
    }
    
    /* Image overlay gradient */
    .category-overlay {
      background: linear-gradient(to top, rgba(139, 94, 60, 0.9), transparent);
    }
    
    /* Pulse animation for new badge */
    @keyframes pulse {
      0%, 100% { opacity: 1; }
      50% { opacity: 0.7; }
    }
    .pulse { animation: pulse 2s cubic-bezier(0.4, 0, 0.6, 1) infinite; }
  </style>
</head>
<body class="bg-gradient-to-br from-amber-50 via-white to-orange-50 min-h-screen">
  <!-- Üst Menü - Profesyonel Header -->
  <header class="bg-white/95 backdrop-blur-md shadow-lg sticky top-0 z-50 border-b-2 border-amber-100">
    <div class="max-w-6xl mx-auto px-4 py-4">
      <div class="flex items-center justify-between">
        <!-- Logo -->
        <a href="index.php" class="flex items-center space-x-3 group">
          <div class="relative">
            <img src="logo.png" alt="<?php echo htmlspecialchars($restaurant_name); ?>" 
                 class="h-14 w-auto max-w-[200px] transition-transform group-hover:scale-105">
          </div>
        </a>
        
        <!-- İletişim Butonları -->
        <div class="flex items-center gap-3">
          <a href="<?php echo htmlspecialchars($maps_url); ?>" target="_blank" 
             class="flex items-center gap-2 bg-gradient-to-r from-blue-500 to-blue-600 text-white px-4 py-2.5 rounded-full hover:shadow-lg transition-all hover:scale-105">
            <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 16 16" class="w-5 h-5">
              <path d="M8 0a5.53 5.53 0 0 0-5.5 5.5c0 3.038 5.5 10.5 5.5 10.5s5.5-7.462 5.5-10.5A5.53 5.53 0 0 0 8 0zm0 8a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5z"/>
            </svg>
            <span class="hidden sm:inline text-sm font-medium">Konum</span>
          </a>
          
          <a href="tel:<?php echo htmlspecialchars($phone); ?>" 
             class="flex items-center gap-2 bg-gradient-to-r from-green-500 to-green-600 text-white px-4 py-2.5 rounded-full hover:shadow-lg transition-all hover:scale-105">
            <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 16 16" class="w-5 h-5">
              <path d="M3.654 1.328a.678.678 0 0 1 .717-.164l2.453.978c.265.105.433.37.433.652v2.01c0 .276-.12.54-.328.71l-1.015.814a11.72 11.72 0 0 0 4.516 4.516l.814-1.015a.734.734 0 0 1 .71-.328h2.01c.282 0 .547.168.652.433l.978 2.453a.678.678 0 0 1-.164.717l-2.017 2.017c-.22.22-.53.304-.829.217a15.573 15.573 0 0 1-8.91-8.91.678.678 0 0 1 .217-.829l2.017-2.017z"/>
            </svg>
            <span class="hidden sm:inline text-sm font-medium">Ara</span>
          </a>
        </div>
      </div>
    </div>
  </header>

  <!-- Hero Section -->
  <div class="max-w-6xl mx-auto px-4 py-8">
    <div class="text-center mb-8 animate-fade-in">
      <h1 class="text-4xl md:text-5xl font-bold bg-gradient-to-r from-amber-700 via-orange-600 to-amber-700 bg-clip-text text-transparent mb-3">
        Dijital Menümüz
      </h1>
      <p class="text-gray-600 text-lg">
        Kategorileri keşfedin ve lezzetli seçeneklerimizi inceleyin
      </p>
      <div class="mt-4 flex items-center justify-center gap-2 text-sm text-amber-700">
        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
          <path fill-rule="evenodd" d="M6 2a1 1 0 00-1 1v1H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-1V3a1 1 0 10-2 0v1H7V3a1 1 0 00-1-1zm0 5a1 1 0 000 2h8a1 1 0 100-2H6z" clip-rule="evenodd"/>
        </svg>
        <span>Son Güncelleme: <?php echo htmlspecialchars($price_update_date); ?></span>
      </div>
    </div>

    <!-- Kategoriler Grid - Profesyonel Cards -->
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6 mb-12">
      <?php foreach ($categories as $index => $category): ?>
        <a href="category.php?slug=<?php echo urlencode($category['slug']); ?>" 
           class="category-card group">
          <div class="bg-white rounded-2xl shadow-lg overflow-hidden h-full hover:shadow-2xl border-2 border-transparent hover:border-amber-300">
            <!-- Görsel Alanı -->
            <div class="relative h-48 overflow-hidden">
              <?php if ($category['image'] && file_exists($category['image'])): ?>
                <img src="<?php echo htmlspecialchars($category['image']); ?>" 
                     alt="<?php echo htmlspecialchars($category['name']); ?>" 
                     class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500">
                <div class="absolute inset-0 category-overlay opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
              <?php else: ?>
                <div class="w-full h-full bg-gradient-to-br from-amber-100 via-orange-50 to-amber-100 flex items-center justify-center">
                  <svg class="w-20 h-20 text-amber-600 group-hover:scale-110 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path>
                  </svg>
                </div>
              <?php endif; ?>
              
              <!-- Sıra Numarası Badge -->
              <div class="absolute top-3 left-3 bg-white/90 backdrop-blur-sm text-amber-800 font-bold text-xs px-3 py-1 rounded-full shadow-lg">
                #<?php echo $index + 1; ?>
              </div>
            </div>
            
            <!-- İçerik Alanı -->
            <div class="p-5">
              <div class="flex items-center justify-between mb-2">
                <h3 class="text-xl font-bold text-gray-800 group-hover:text-amber-700 transition-colors">
                  <?php echo htmlspecialchars($category['name']); ?>
                </h3>
                <svg class="w-6 h-6 text-amber-600 group-hover:translate-x-2 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                </svg>
              </div>
              
              <!-- Ürün Sayısı (opsiyonel - veritabanından çekebilirsiniz) -->
              <div class="flex items-center gap-2 text-sm text-gray-500">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                </svg>
                <span>Menüyü görüntüle</span>
              </div>
            </div>
          </div>
        </a>
      <?php endforeach; ?>
    </div>

    <!-- Footer Info -->
    <div class="bg-white/80 backdrop-blur-sm rounded-2xl shadow-lg p-8 border border-amber-100">
      <div class="text-center">
        <div class="flex items-center justify-center gap-3 mb-4">
          <div class="h-px flex-1 bg-gradient-to-r from-transparent via-amber-300 to-transparent"></div>
          <svg class="w-8 h-8 text-amber-600" fill="currentColor" viewBox="0 0 20 20">
            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
          </svg>
          <div class="h-px flex-1 bg-gradient-to-r from-transparent via-amber-300 to-transparent"></div>
        </div>
        
        <h3 class="text-2xl font-bold text-gray-800 mb-2">
          Hoş Geldiniz!
        </h3>
        <p class="text-gray-600 mb-6 max-w-2xl mx-auto">
          Demo QR Cafe olarak sizlere en kaliteli hizmeti sunmak için buradayız. 
          Lezzetli yemeklerimizi keşfedin.
        </p>
        
        <!-- İletişim Bilgileri -->
        <div class="flex flex-wrap items-center justify-center gap-6 text-sm">
          <div class="flex items-center gap-2 text-gray-700">
            <svg class="w-5 h-5 text-amber-600" fill="currentColor" viewBox="0 0 20 20">
              <path d="M2 3a1 1 0 011-1h2.153a1 1 0 01.986.836l.74 4.435a1 1 0 01-.54 1.06l-1.548.773a11.037 11.037 0 006.105 6.105l.774-1.548a1 1 0 011.059-.54l4.435.74a1 1 0 01.836.986V17a1 1 0 01-1 1h-2C7.82 18 2 12.18 2 5V3z"/>
            </svg>
            <a href="tel:<?php echo htmlspecialchars($phone); ?>" class="hover:text-amber-700 font-medium">
              <?php echo htmlspecialchars($phone); ?>
            </a>
          </div>
          
          <div class="flex items-center gap-2 text-gray-700">
            <svg class="w-5 h-5 text-amber-600" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M5.05 4.05a7 7 0 119.9 9.9L10 18.9l-4.95-4.95a7 7 0 010-9.9zM10 11a2 2 0 100-4 2 2 0 000 4z" clip-rule="evenodd"/>
            </svg>
            <span class="font-medium">Bursa, Türkiye</span>
          </div>
        </div>
      </div>
    </div>

    <!-- Copyright -->
    <div class="text-center mt-8 text-sm text-gray-500">
      <p>© <?php echo date('Y'); ?> <?php echo htmlspecialchars($restaurant_name); ?>. Tüm hakları saklıdır.</p>
    </div>
  </div>

</body>
</html>